
var rain = [];
var rainingNow = false;
var bgcolor = (100, 100, 100);
let song;
let rainsound;
let button;
let jumpButton;
let img;

function preload() {
  song= loadSound("raindroptrail.mp3", loaded);
  rainsound= loadSound("raining.wav", loaded);
}

function setup() {
  createCanvas(600, 600);
  img = loadImage('alone.jpg'); 
  //frameRate(60);
  
  button= createButton("play");
  button.mousePressed(togglePlaying);
  jumpButton= createButton("jump");
  jumpButton.mousePressed(jumpSong);
  
  for (i = 0; i < 300; i++) {
    rain[i] = new Rain(random(50, 550), random(0, -3000));
  }
}
function loaded(){
  console.log("loaded")
}
function jumpSong(){
  let len = song.duration();
  song.jump(random(len));
}
function draw() {
  background(img);
  // image(img, 0, 0);
  // image(img, 0, 0, img.width, img.height);

  //Check if it's raining or sunny
  if (rainingNow == true) {
    //background(100);
    for (i = 0; i < rain.length; i++) {
      rain[i].dropRain();
      rain[i].splash();
    }
  } else {
      //add second state here
  }
}

function togglePlaying (){
  if (!song.isPlaying()){
      song.play();
      rainsound.play();
      rainsound.setVolume(0.1);
      song.setVolume(0.3);
      button.html("pause");
      rainingNow = true;

  }
  else{
      song.pause();
      rainsound.pause();
      button.html("play");
      rainingNow = false;
  }
}


function Rain(x, y) {
  this.x = x;
  this.y = y;
  //this.gravity = 9.8;
  this.length = 15;
  this.r = 0;
  this.opacity = 200;


  this.dropRain = function() {
    noStroke();
    fill(255);
    //rect(this.x, this.y,3,15);
    ellipse(this.x, this.y, 3, this.length);
    this.y = this.y + 6 //+ frameCount/60;
    if (this.y > 540) {
      this.length = this.length - 5;
      //this.y= random(0,-100);
    }
    if (this.length < 0) {
      this.length = 0;
    }
  }

  this.splash = function() {
    strokeWeight(2);
    //stroke(245, 200/frameCount);
    stroke(245, this.opacity);
    noFill();
    if (this.y > 540) {
      ellipse(this.x, 550, this.r * 2, this.r / 2);
      this.r++;
      this.opacity = this.opacity - 10;

      //keep the rain dropping
      if (this.opacity < 0) {
        this.y = random(0, -100);
        this.length = 15;
        this.r = 0;
        this.opacity = 200;
        //console.log("splash");
      }
    }
    
  }
}
